;$NOLIST

; SS:SP does not have to be set up here.  It is initialized by the loader.

        NAME  MiniStart

padIntVect EQU 60H

PUBLIC   DosAlloc, DosFree

CGROUP   GROUP CODE
DGROUP   GROUP DATA


DATA     SEGMENT  PUBLIC 'DATA'
DATA     ENDS


CODE     SEGMENT  PUBLIC 'CODE'

EXTRN  pMyProgName: DWORD, MsProgramName: NEAR, Main: NEAR

ASSUME   CS:CGROUP

Start:
	MOV  AX, DGROUP
	MOV	DS, AX	; Set up DS for "Main" program

	PUSH	AX	; Save room on stack for program name length
	MOV	SI, SP
	PUSH	SS
	PUSH	SI	; Need to get the name of this program
	CALL	MsProgramName	; to be able to look for resources later
	MOV	WORD PTR CS:pMyProgName+2, ES
	MOV	WORD PTR CS:pMyProgName+0, BX
	POP	CX

	CALL	Main	; Call entrypoint of test program

	MOV	AX, 4C00H	; Exit program (in case Main didn't!)
	INT	21H	; Call MsDos
;$EJECT

;  DosAlloc

;  This is a procedural interface to the INT 21H, function 48H call
;  It is called instead of doing an INT 21H directly, so that some
;  versions of the MiniGRiD TSR can use their own memory managers.
;  This will return a pointer to a block of allocated memory.

;  Entry
;    BX = Number of paragraphs requested

;  Exit (No error; i.e. carry flag not set)
;    AX = Address of block of memory

;  Exit (error; i.e. carry flag set)
;    AX = error code if error
;	 BX is supposed to have number of blocks available!

DosAlloc PROC NEAR
	MOV	AH, 48H
	INT	21H
	RET
DosAlloc ENDP
;$EJECT

;  DosFree

;  This is a procedural interface identical to the INT 21H, function 49H call
;  It is called instead of doing an INT 21H directly, so that some
;  versions of the MiniGRiD TSR can use their own memory managers.

;  Entry
;    ES = Address of memory block to be freed

;  Exit
;    AX = Error code if error (carry flag set)

DosFree PROC NEAR
	MOV	AH, 49H
	INT	21H
	RET
DosFree ENDP


CODE  ENDS

END   Start
